/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.fluent.collections;

import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableMapImpl;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.fluent.collections.UnmodifiableMap;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;

public interface ImmutableMap<K, V>
extends UnmodifiableMap<K, V> {
    public static <K, V> ImmutableMap<K, V> of(K k1, V v1) {
        return ImmutableMapImpl.of(k1, v1);
    }

    public static <K, V> ImmutableMap<K, V> of(K k1, V v1, K k2, V v2) {
        return ImmutableMapImpl.of(k1, v1, k2, v2);
    }

    public static <K, V> ImmutableMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3) {
        return ImmutableMapImpl.of(k1, v1, k2, v2, k3, v3);
    }

    public static <K, V> ImmutableMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        return ImmutableMapImpl.of(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static <K, V> ImmutableMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        return ImmutableMapImpl.of(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    public static <K, V> ImmutableMap<K, V> ofNonNull(K k1, V v1) {
        return ImmutableMapImpl.ofNonNull(k1, v1);
    }

    public static <K, V> ImmutableMap<K, V> ofNonNull(K k1, V v1, K k2, V v2) {
        return ImmutableMapImpl.ofNonNull(k1, v1, k2, v2);
    }

    public static <K, V> ImmutableMap<K, V> ofNonNull(K k1, V v1, K k2, V v2, K k3, V v3) {
        return ImmutableMapImpl.ofNonNull(k1, v1, k2, v2, k3, v3);
    }

    public static <K, V> ImmutableMap<K, V> ofNonNull(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        return ImmutableMapImpl.ofNonNull(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static <K, V> ImmutableMap<K, V> ofNonNull(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        return ImmutableMapImpl.ofNonNull(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    public static <K, V> ImmutableMap<K, V> of(Map<K, V> map) {
        return ImmutableMapImpl.of(map);
    }

    public static <K, V> ImmutableMap<K, V> of(Map<K, V> map, K k1, V v1) {
        return ImmutableMapImpl.of(map, k1, v1);
    }

    public static <K, V> ImmutableMap<K, V> of(Map<K, V> map, K k1, V v1, K k2, V v2) {
        return ImmutableMapImpl.of(map, k1, v1, k2, v2);
    }

    public static <K, V> ImmutableMap<K, V> without(Map<K, V> map, K key) {
        return ImmutableMapImpl.without(map, key);
    }

    public static <C, K, V> ImmutableMap<K, V> map(Collection<C> collection, Function<C, Map.Entry<K, V>> mappingFunction) {
        return ImmutableMapImpl.map(collection, mappingFunction);
    }

    public static <KS, VS, KT, VT> ImmutableMap<KT, VT> map(Map<KS, VS> source, Function<KS, KT> keyMappingFunction, Function<VS, VT> valueMappingFunction) {
        return ImmutableMapImpl.map(source, keyMappingFunction, valueMappingFunction);
    }

    public static <K, V> Map.Entry<K, V> entry(K k1, V v1) {
        return new AbstractMap.SimpleImmutableEntry<K, V>(k1, v1);
    }

    public static <K, V> ImmutableMap<K, V> empty() {
        return ImmutableMapImpl.empty();
    }

    public ImmutableMap<K, V> without(K var1);

    public ImmutableMap<K, V> with(K var1, V var2);

    public ImmutableMap<K, V> with(ImmutableMap<K, V> var1);

    public ImmutableMap<K, V> withComputed(K var1, Function<V, V> var2);

    public ImmutableMap<K, V> matching(Predicate<K> var1);

    public ImmutableMap<K, V> intersection(ImmutableSet<K> var1);

    public boolean containsAny(ImmutableSet<K> var1);

    @Override
    public ImmutableSet<K> keySet();

    @Override
    public ImmutableSet<Map.Entry<K, V>> entrySet();

    public ImmutableList<V> values(BiPredicate<K, V> var1);

    public ImmutableList<V> valuesForKeys(ImmutableSet<K> var1);

    public <KT, VT> ImmutableMap<KT, VT> map(Function<K, KT> var1, Function<V, VT> var2);

    public <VT> ImmutableMap<K, VT> mapValues(Function<V, VT> var1);

    public boolean forAllKeysApplies(Predicate<K> var1);

    public boolean forAnyKeyApplies(Predicate<K> var1);

    public <KT, VT> ImmutableMap<KT, VT> assertElementType(Class<KT> var1, Class<VT> var2);

    public <KT> ImmutableMap<KT, V> ensureKeyType(Class<KT> var1, Function<Object, KT> var2);

    public static class Builder<K, V> {
        private ImmutableMapImpl.InternalBuilder<K, V> internalBuilder;
        private Function<K, V> defaultSupplier;

        public Builder() {
            this.internalBuilder = new ImmutableMapImpl.HashArrayBackedMap.Builder(16);
        }

        public Builder(int expectedNumberOfElements) {
            this.internalBuilder = expectedNumberOfElements <= 25 ? new ImmutableMapImpl.HashArrayBackedMap.Builder(16) : (expectedNumberOfElements <= 100 ? new ImmutableMapImpl.HashArrayBackedMap.Builder(64) : (expectedNumberOfElements <= 400 ? new ImmutableMapImpl.HashArrayBackedMap.Builder(256) : new ImmutableMapImpl.MapBackedMap.Builder(expectedNumberOfElements)));
        }

        public Builder(Map<K, V> initialContent) {
            if (initialContent instanceof ImmutableMapImpl.HashArrayBackedMap) {
                this.internalBuilder = new ImmutableMapImpl.HashArrayBackedMap.Builder((ImmutableMapImpl.HashArrayBackedMap)initialContent);
            } else if (initialContent.size() <= 25) {
                this.internalBuilder = new ImmutableMapImpl.HashArrayBackedMap.Builder(16);
                for (Map.Entry<K, V> entry : initialContent.entrySet()) {
                    this.internalBuilder = this.internalBuilder.with(entry.getKey(), entry.getValue());
                }
            } else if (initialContent.size() <= 100) {
                this.internalBuilder = new ImmutableMapImpl.HashArrayBackedMap.Builder(64);
                for (Map.Entry<K, V> entry : initialContent.entrySet()) {
                    this.internalBuilder = this.internalBuilder.with(entry.getKey(), entry.getValue());
                }
            } else if (initialContent.size() <= 400) {
                this.internalBuilder = new ImmutableMapImpl.HashArrayBackedMap.Builder(256);
                for (Map.Entry<K, V> entry : initialContent.entrySet()) {
                    this.internalBuilder = this.internalBuilder.with(entry.getKey(), entry.getValue());
                }
            } else {
                this.internalBuilder = new ImmutableMapImpl.MapBackedMap.Builder<K, V>(initialContent);
            }
        }

        public Builder<K, V> defaultValue(Function<K, V> defaultSupplier) {
            this.defaultSupplier = defaultSupplier;
            return this;
        }

        public Builder<K, V> with(K key, V value) {
            if (key == null) {
                throw new IllegalArgumentException("null keys are not allowed");
            }
            this.internalBuilder = this.internalBuilder.with(key, value);
            return this;
        }

        public Builder<K, V> with(Map<K, V> map) {
            if (!map.isEmpty()) {
                this.internalBuilder = this.internalBuilder.with(map);
            }
            return this;
        }

        public void put(K key, V value) {
            if (key == null) {
                throw new IllegalArgumentException("null keys are not allowed");
            }
            this.internalBuilder = this.internalBuilder.with(key, value);
        }

        public void putAll(Map<K, V> map) {
            if (!map.isEmpty()) {
                this.internalBuilder = this.internalBuilder.with(map);
            }
        }

        public boolean remove(K e) {
            return this.internalBuilder.remove(e);
        }

        public boolean contains(K e) {
            return this.internalBuilder.contains(e);
        }

        public V get(K k) {
            V result = this.internalBuilder.get(k);
            if (result == null && this.defaultSupplier != null && (result = this.defaultSupplier.apply(k)) != null) {
                this.put(k, result);
            }
            return result;
        }

        public ImmutableMap<K, V> build() {
            return this.internalBuilder.build();
        }

        public <V2> ImmutableMap<K, V2> build(Function<V, V2> valueMappingFunction) {
            return this.internalBuilder.build(valueMappingFunction);
        }

        public int size() {
            return this.internalBuilder.size();
        }

        public Set<K> keySet() {
            return this.internalBuilder.keySet();
        }
    }
}

